/*
 * 著作権: Copyright (c) 2007－2008 ZIGEN
 * ライセンス：Eclipse Public License - v 1.0
 * 原文：http://www.eclipse.org/legal/epl-v10.html
 */

package zigen.plugin.db.ext.s2jdbc.wizards;

import java.util.List;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Table;

import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ui.editors.internal.TableViewerManager;

/**
 * 
 * TableKeyEventHandlerクラス.
 * 
 * @author ZIGEN
 * @version 1.0
 * @since JDK1.4 history Symbol Date Person Note [1] 2006/02/08 ZIGEN create.
 * 
 */
public class TableKeyEventHandler2 {
	
	protected TableViewer viewer;
	
	protected Table table;
	
	/**
	 * コンストラクタ
	 * 
	 */
	public TableKeyEventHandler2(TableViewer viewer) {
		this.viewer = viewer;
		this.table = viewer.getTable();
	}
	
	/**
	 * 選択している行番号を取得
	 * 
	 * @return
	 */
	public int getSelectedRow() {
		return table.getSelectionIndex(); // 行（先頭は0から)
	}
	
	public void selectRow(int index) {
		table.select(index);
	}
	
	/**
	 * 選択している列番号を取得
	 * 
	 * @return
	 */
	public int getSelectedCellEditorIndex() {
		int defaultIndex = 0;
		CellEditor[] editors = viewer.getCellEditors();
		if (editors == null)
			return -1;
		for (int i = 0; i < editors.length; i++) {
			if (editors[i] != null && editors[i].isActivated()) {
				return i;
			}
		}
		return defaultIndex;
	}
	
	/**
	 * 編集可能な次の列番号を取得
	 * 
	 * @param cuurentCol
	 * @return
	 */
	public int getEditableNextColumn(int cuurentCol) {
		ICellModifier modifier = viewer.getCellModifier();
		// int nextCol = (cuurentCol < table.getColumnCount() - 1) ? cuurentCol + 1 : 1;
		int nextCol = (cuurentCol < table.getColumnCount() - 1) ? cuurentCol + 1 : 2;// (ダミー分を考慮)
		// int nextCol = (cuurentCol < table.getColumnCount() - 2) ? cuurentCol + 1 : 2;// (チェックボックス分を考慮)
		
		System.out.println("nextCol = " + nextCol);
		return nextCol;
	}
	
	/**
	 * 編集可能な前の列番号を取得
	 * 
	 * @param CurrentCol
	 * @return
	 */
	public int getEditablePrevColumn(int CurrentCol) {
		ICellModifier modifier = viewer.getCellModifier();
		// int nextCol = (CurrentCol == 1) ? table.getColumnCount() - 1 : CurrentCol - 1;
		int nextCol = (CurrentCol == 2) ? table.getColumnCount() - 1 : CurrentCol - 1; // (ダミー分を考慮)
		// int nextCol = (CurrentCol == 2) ? table.getColumnCount() - 1 : CurrentCol - 1; // (チェックボックス分を考慮)
		System.out.println("nextCol = " + nextCol);
		return nextCol;
	}
	
	/**
	 * 指定したカラムを編集モードにする
	 * 
	 * @param rowIndex
	 *            行番号
	 * @param columnIndex
	 *            列番号
	 */
	public void editTableElement(int rowIndex, int columnIndex) {
		Object element = viewer.getElementAt(rowIndex);
		if (element != null) {
			
			// うまく横スクロールして編集モードにならない
			// viewer.editElement(element, columnIndex);
			// table.showColumn(table.getColumn(columnIndex));
			
			// 順番入れかえることで、うまくスクロール＋編集モードになる
			if (columnIndex == 1) {
				table.showColumn(table.getColumn(0)); // 行番号を見えるようにする
			} else {
				table.showColumn(table.getColumn(columnIndex));
			}
			viewer.editElement(element, columnIndex);
			
		}
	}
	
	/**
	 * 画面上のカラム文字列を更新する
	 * 
	 */
	public void updateColumn(FormProperty element, int col, Object newValue) {
		
		// TableElementの値を更新し、編集済みリストに追加
		// element.updateItems(col - 1, newValue);// row分-1する
		
		element.setValue(col, String.valueOf(newValue));
		
		// テーブル・ビューワを更新
		viewer.update(element, null);
		columnsPack();
		
	}
	
	public void setMessage(String msg) {
		DbPlugin.getDefault().showWarningMessage(msg);
	}
	
	/**
	 * Row番号のカラムのPack
	 */
	private void columnsPack() {}
	
	
	/**
	 * 入力チェックおよび更新データをTableElementに登録する
	 * 
	 * @param row
	 * @param col
	 * @return
	 */
	public boolean validate(int row, int col) {
		FormProperty element = (FormProperty) viewer.getElementAt(row);
		Object newValue = null;
		CellEditor editor = viewer.getCellEditors()[col];
		if (editor == null)
			throw new IllegalStateException("CellEditorが設定されていません"); //$NON-NLS-1$
			
		// int columnIndex = -1;
		
		if (editor instanceof TextCellEditor) {
			TextCellEditor tce = (TextCellEditor) editor;
			newValue = tce.getValue();
		}
		Object oldValue = element.getValue(col);
		
		// if (!oldValue.equals(newValue)) {
		// String msg = editor.getErrorMessage();
		// if (msg == null) {
		// // 見た目更新
		// updateColumn(element, col, newValue);
		// return true; // 成功
		//
		// } else {
		// // 編集をキャンセル(modifyが呼ばれないようにする)
		// viewer.cancelEditing();
		// // 見た目を更新
		// updateColumn(element, col, newValue);
		// // エラーメッセージ表示
		// setMessage(msg); //$NON-NLS-1$
		// // 入力元のカラムを編集状態にする
		// editTableElement(row, col);
		// return false; // 失敗
		// }
		//
		// }
		
		String msg = editor.getErrorMessage();
		if (msg == null) {
			// 見た目更新
			updateColumn(element, col, newValue);
			return true; // 成功
			
		} else {
			// 編集をキャンセル(modifyが呼ばれないようにする)
			viewer.cancelEditing();
			// 見た目を更新
			updateColumn(element, col, newValue);
			// エラーメッセージ表示
			setMessage(msg); //$NON-NLS-1$
			// 入力元のカラムを編集状態にする
			editTableElement(row, col);
			return false; // 失敗
		}
		

	}
	
	// public boolean validateAll() {
	// // log.debug("validateAll");
	// try {
	// int row = getSelectedRow();
	//
	// if (row == -1) {
	// ;// CTRL+Cの場合はこちら
	// } else {
	// FormProperty element = (FormProperty) viewer.getElementAt(row);
	// IDBConfig config = element.getTable().getDbConfig();
	// IValidatorFactory factory = AbstractValidatorFactory.getFactory(config);
	// zigen.plugin.db.core.TableColumn[] columns = element.getColumns();
	// String msg = null;
	// for (int col = 0; col < columns.length; col++) {
	// //
	// // if(!validate(row, col+1)){
	// // return false;
	// // }
	//
	//
	// Object[] items = element.getItems();
	// msg = factory.validate(columns[col], items[col]);
	// if (msg != null) {
	// viewer.cancelEditing();
	// setMessage(msg);
	// editTableElement(row, col + 1); // row分追加 (ここでは col+1)
	// return false;
	// }
	// }
	// }
	//
	// } catch (Exception e) {
	// e.printStackTrace();
	// DbPlugin.getDefault().showErrorDialog(e);
	// }
	// return true;
	// }
	
	/**
	 * 画面上の新規用レコードを削除する ※データベースへの削除は行わない（あくまでも見た目上）
	 * 
	 */
	public void removeRecord(FormProperty element) {
		TableViewerManager.remove(viewer, element);
	}
	
	/**
	 * コネクションの開放
	 */
	public void dispose() {}
	
	
	/**
	 * テーブルに新規登録用のレコードを表示する
	 * 
	 */
	public void createNewRecord() {
		
		int count = table.getItems().length;
		
		FormProperty fp = new FormProperty();
		fp.no = count + 1;
		fp.name = "";
		fp.type = "String";
		fp.modified = FormProperty.MODIFIED_PUBLIC;
		
		addFormProperty(viewer, fp);
		// １カラム目(Rowを除いたもの）を編集
		// editTableElement(count, 1); // 最終レコードの1カラム目を編集
		editTableElement(count, 2); // 最終レコードの2カラム目を編集(ダミー分を考慮)
		
	}
	
	@SuppressWarnings("unchecked")
	private void addFormProperty(TableViewer viewer, FormProperty newProperty) {
		Object obj = viewer.getInput();
		if (obj instanceof List<?>) {
			List<FormProperty> list = (List<FormProperty>) obj;
			list.add(newProperty);
			viewer.setInput(list);
			
		} else {
			throw new IllegalArgumentException("TableViewerに格納されているオブジェクトが異なります"); //$NON-NLS-1$
		}
	}
}
